'/**************************************/;
'/* Program Demo For ET-ROBOT RD2 V1.0 */;
'/* Controller  : P89C51RD2(Philips)   */;
'/* Run X-TAL   : 18.432 Mhz           */;
'/*             : X2 Mode(6 Cycle Run) */;
'/* Complier    : BASCOM-51(V2.0.11.0) */;
'/* Write By    : Eakachai Makarn      */;
'/* File Update : December-2003        */;
'/* Read A/D (ADS7841) & Show Volt LCD */;
'/* Built-In AD Function on Subroutine */;
'/**************************************/;
'
$regfile = "89c51rd.dat"                                      'P89C51RD2(Philips)
$ramstart = 0
$ramsize = 256
$crystal = 36864000                                           '18.432MHz (X2 Mode)

Config Lcdpin = Pin , Db4 = P2.0 , Db5 = P2.1 , Db6 = P2.2 , Db7 = P2.3 , E = P2.4 , Rs = P2.5
Config Lcd = 16 * 2
Cursor Off                                                    'Not Display Cursor LCD

Ads7841_dclk Alias P3.3                                       'Clock Input
Ads7841_cs Alias P3.4                                         'Chips Select
Ads7841_din Alias P3.5                                        'Data Input
Ads7841_dout Alias P3.7                                       'Data Output

Declare Sub Ads7841(ad_channel As Byte , Ad_result As Word)   'Sub Program For Read A/D
Dim Ad_channel As Byte                                        'Variable For Declare Channel A/D
Dim Ad_result As Word                                         'Variable For Save A/d Result
Dim Adc_calculate As Single                                   'Variable For Convert A/D Step to Volt
Dim Adc_display As String * 8

Cls                                                           'Clear Display
Lcd "DEMO ADS7841 A/D"
Locate 2 , 1                                                  'Line2 Position1
Lcd "ADC 0 =     Volt"
Do
  Ads7841 , 0 , Ad_result                                     'Read ADC CH0
  Adc_calculate = Ad_result                                   'Convert to Floating Point
  Adc_calculate = Adc_calculate * 0.0012210                   'Step * (5/4095)
  Adc_display = Fusing(adc_calculate , #.#)                   'Display 1 Digit Floating Point
  Locate 2 , 9                                                'Line2 Position 9
  Lcd Adc_display                                             'Display Result
Loop


Sub Ads7841(ad_channel As Byte , Ad_result As Word)           'Sub Program Read A/D
    $asm
      mov r0,#{ad_result}                                                   ;Addres Low Byte Variable Save Data
      mov r1,{ad_channel}                                                   ;Channel 0-3
      ;
      SETB {ADS7841_CS}                                                     ;Initial CS
      CLR     {ADS7841_DCLK}                                                ;Initial DCLK

      MOV     A,R1                                                          ; Get Channel
      CJNE A,#0,_ch1_7841
      MOV     A,#&B10010111                                              ; CH0,SGL,POWER
      SJMP _START_7841
      ;
    _ch1_7841:
      CJNE A,#1,_CH2_7841
      MOV     A,#&B11010111                                                 ;CH1,SGL,POWER
      SJMP _START_7841
    _ch2_7841:
      CJNE A,#2,_CH3_7841
      MOV     A,#&B10100111                                                 ;CH2,SGL,POWER
      SJMP _START_7841

    _ch3_7841:
      MOV     A,#&B11100111                                                 ;CH3,SGL,POWER

    _start_7841:
      MOV     R2,#8                                                         ;LOOP CONTROL BYTE
      CLR     {ADS7841_CS}
    _write_ads7841:
      RLC     A
      MOV     {ADS7841_DIN},C
      SETB    {ADS7841_DCLK}
      CLR     {ADS7841_DCLK}
      DJNZ    R2,_WRITE_ADS7841

      SETB    {ADS7841_DCLK}                                                ;Skip Busy
      CLR     {ADS7841_DCLK}

      MOV     R2,#8                                                         ;Loop Read High Byte Data
    _read_high:
      SETB    {ADS7841_DCLK}
      MOV     C,{ADS7841_DOUT}
      CLR     {ADS7841_DCLK}
      RLC     A
      DJNZ    R2,_READ_HIGH
      MOV     DPH,A                                                         ;Save Data High Byte

      MOV     R2,#8                                                         ;Loop Read Low Byte Data
    _read_low:
      SETB    {ADS7841_DCLK}
      MOV     C,{ADS7841_DOUT}
      CLR     {ADS7841_DCLK}
      RLC     A
      DJNZ    R2,_READ_LOW
      MOV     DPL,A                                                         ;Save Data Low Byte
      SETB    {ADS7841_CS}                                                  ;DISABLE ADC

      MOV     R2,#4                                                         ;Shift Result
    _shift_result:
      MOV     A,DPH
      RRC     A
      MOV     DPH,A
      MOV     A,DPL
      RRC     A
      MOV     DPL,A
      DJNZ    R2,_SHIFT_RESULT
      ;
      MOV     A,DPL                                                         ;Get Result Low Byte
      MOV     @R0,A                                                         ;Save Low Byte Result
      INC R0                                                                ;Next Point to High Byte
      MOV A,DPH                                                             ;Get Result High Byte
      ANL     A,#&H0F
      MOV @R0,A                                                             ;Save High Byte Result
      RET
    $end Asm
End Sub